% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_yaml.R
\name{write_yaml}
\alias{write_yaml}
\title{Write a YAML file}
\usage{
write_yaml(x, file, fileEncoding = "UTF-8", ...)
}
\arguments{
\item{x}{The object to be converted.}

\item{file}{Either a character string naming a file or a \link{connection}
open for writing.}

\item{fileEncoding}{Character string: if non-empty declares the encoding to
be used on a file (not a connection) so the character data can be
re-encoded as they are written. See \code{\link[=file]{file()}}.}

\item{\dots}{Arguments to \code{\link[=as.yaml]{as.yaml()}}.}
}
\description{
Write the YAML representation of an R object to a file
}
\details{
If \code{file} is a non-open connection, an attempt is made to open it and
then close it after use.

This function is a convenient wrapper around \code{\link[=as.yaml]{as.yaml()}}.
}
\examples{

\dontrun{
  # writing to a file connection
  filename <- tempfile()
  con <- file(filename, "w")
  write_yaml(data.frame(a=1:10, b=letters[1:10], c=11:20), con)
  close(con)

  # using a filename to specify output file
  write_yaml(data.frame(a=1:10, b=letters[1:10], c=11:20), filename)
}

}
\seealso{
\code{\link[=as.yaml]{as.yaml()}}, \code{\link[=read_yaml]{read_yaml()}},
\code{\link[=yaml.load_file]{yaml.load_file()}}
}
\author{
Jeremy Stephens \href{mailto:jeremy.f.stephens@vumc.org}{jeremy.f.stephens@vumc.org}
}
\keyword{data}
\keyword{manip}
