% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.2.1.R
\name{tsmovav}
\alias{tsmovav}
\alias{print.tsmovav}
\alias{plot.tsmovav}
\title{Generate Moving Averages of a Time Series}
\usage{
tsmovav(
  x,
  order = 3,
  type = c("backward", "center"),
  n.ahead = 0,
  x.name = NULL,
  show.plot = TRUE
)

\method{print}{tsmovav}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{plot}{tsmovav}(x, title = NULL, ...)
}
\arguments{
\item{x}{a univariate time series object or a numeric vector or matrix, or a `tsmovav` object.}

\item{order}{moving average order. Default is \code{3}.}

\item{type}{type of moving average to be calculated. Available options are "\code{backward}" and "\code{center}". While \code{backward} assigns the moving averages to the next period after the averaging window, which is more useful for forecasting purpose, \code{center} assigns the moving averages to the middle period of the averaging window, which is more suitable for time series smoothing. Default is `\code{backward}`.}

\item{n.ahead}{number of forecasting periods. Only useful if "\code{type = backward}". Default is \code{0}.}

\item{x.name}{a new name for \code{x}. If the parameter is omitted, the current name of the time series will be returned to the user.}

\item{show.plot}{logical. If \code{TRUE}, the smoothing/forecasting plot will be displayed directly. Default is \code{TRUE}.}

\item{digits}{the number of significant digits.}

\item{...}{other printing or plotting parameters.}

\item{title}{title of the moving average plot. Default is \code{NULL}.}
}
\value{
\item{x}{original series data}

\item{x.time}{list of time in which the series values were observed.}

\item{x.timegap}{time gap between the series and forecasted values.}

\item{x.name}{name of the time series for which forecasts was requested.}

\item{pred}{predicted past values and forecasted future values.}

\item{pred.time}{list of time in which the predictions/forecasts were estimated.}

\item{pred.name}{name of the series containing the predicted/forecasted values.}

\item{se}{standard errors of the forecasted values.}

\item{cil, ciu}{lower and upper limits of the prediction interval.}

\item{n.ahead}{number of forecasting periods.}

\item{forecast.incl}{indication of the series part that should be predicted or forecasted.}

\item{log}{logical. Indicates whether series values are log-transformed for model fitting or not.}

\item{alpha}{significance level.}

\item{order}{moving average order.}

\item{type}{type of moving average.}
}
\description{
The function `\code{tsmovav}` calculates the moving averages of a time series.
}
\details{
Centred moving averages are better suited for smoothing a time series than for forecasting. By definition, each moving average is aligned with the midpoint of its averaging window. When the number of periods in the averaging window (i.e., the moving average order) is even, the averages calculated for the two central positions must be combined. Specifically, the mean of these two middle moving averages is assigned to the central period that lies closest to the true midpoint of the series, forming its final centred moving average.

Mathematically, for odd number order \eqn{r}:

\deqn{\tilde{y}_t = \dfrac{y_{t-\frac{r-1}{2}}+\ldots+y_{t+\frac{r+1}{2}}}{r}}

For even number order \eqn{r}:

\deqn{\tilde{y}_t = \dfrac{0.5y_{t-\frac{r}{2}}+y_{t-\frac{r}{2}+1}+\ldots+y_{t+\frac{r}{2}-1}+0.5y_{t+\frac{r}{2}}}{2r}}

Backward moving average is a forecasting method that assigns each computed average to the period immediately following the observation window. This approach works the same regardless of whether the moving average order is odd or even.

\deqn{\tilde{y}_t = \dfrac{y_{t-1}+\ldots+x_{y-r}}{r}}
}
\examples{
## Backward Moving Average
tsmovav(airport$Travellers, order = 12, type = "backward", n.ahead = 6, show.plot = TRUE)

## Centered Moving Average
tsmovav(airport$Travellers, order = 12, type = "center")
}
\references{
Hyndman, R. J., & Athanasopoulos, G. (2021). Forecasting: Principles and practice (3rd ed.). OTexts. \cr \url{https://otexts.com/fpp3/}
}
\author{
Ka Yui Karl Wu
}
