% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{survQuantile}
\alias{survQuantile}
\title{Brookmeyer-Crowley Confidence Interval for Quantiles of
Right-Censored Time-to-Event Data}
\usage{
survQuantile(
  time,
  event,
  cilevel = 0.95,
  transform = "loglog",
  probs = as.numeric(c(0.25, 0.5, 0.75))
)
}
\arguments{
\item{time}{The vector of possibly right-censored survival times.}

\item{event}{The vector of event indicators.}

\item{cilevel}{The confidence interval level. Defaults to 0.95.}

\item{transform}{The transformation of the survival function to use
to construct the confidence interval. Options include
"linear" (alternatively "plain"), "log",
"loglog" (alternatively "log-log" or "cloglog"),
"asinsqrt" (alternatively "asin" or "arcsin"), and "logit".
Defaults to "loglog".}

\item{probs}{The vector of probabilities to calculate the quantiles.
Defaults to c(0.25, 0.5, 0.75).}
}
\value{
A data frame containing the estimated quantile and
confidence interval corresponding to each specified probability.
It includes the following variables:
\itemize{
\item \code{prob}: The probability to calculate the quantile.
\item \code{quantile}: The estimated quantile.
\item \code{lower}: The lower limit of the confidence interval.
\item \code{upper}: The upper limit of the confidence interval.
\item \code{cilevel}: The confidence interval level.
\item \code{transform}: The transformation of the survival function to use
to construct the confidence interval.
}
}
\description{
Obtains the Brookmeyer-Crowley confidence
interval for quantiles of right-censored time-to-event data.
}
\examples{

survQuantile(
  time = c(33.7, 3.9, 10.5, 5.4, 19.5, 23.8, 7.9, 16.9, 16.6,
           33.7, 17.1, 7.9, 10.5, 38),
  event = c(0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1),
  probs = c(0.25, 0.5, 0.75))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
