% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.msm.R
\name{plot.msm}
\alias{plot.msm}
\title{Plot method for msm objects}
\usage{
\method{plot}{msm}(x, time_unit = "day", show_hr = TRUE, show_risk = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{msm}.}

\item{time_unit}{The time unit used in the input data.
Options are "day" (default), "week", "month", or "year".}

\item{show_hr}{Logical; whether to show hazard ratio on the KM plot.
Default is TRUE.}

\item{show_risk}{Logical; whether to show number at risk table
below the KM plot. Default is TRUE.}

\item{...}{Ensures that all arguments starting from "..." are named.}
}
\value{
A list of two ggplot2 objects, one for histogram and the other
for KM plot.
}
\description{
Generate histogram of weights and weighted Kaplan-Meier (KM)
plot for censored outcomes of an msm object.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
\keyword{internal}
