% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect_class_thresh.R
\name{collect_class_thresh}
\alias{collect_class_thresh}
\title{Obtain and format the class thresholds for ensemble objects}
\usage{
collect_class_thresh(x, ...)
}
\arguments{
\item{x}{A \code{\link{simple_ensemble}}}

\item{...}{Not currently used.}
}
\value{
A tibble.
}
\description{
Return a tibble of class thresholds, as computed by \code{calib_class_thresh()}.
}
\examples{
\dontshow{if (rlang::is_installed("earth")) withAutoprint(\{ # examplesIf}
test_ens <- simple_ensemble() \%>\%
  add_member(two_class_res[1:3, ], metric = "roc_auc")
test_ens <- calib_class_thresh(test_ens, class_thresh = "tss_max")
test_ens <- calib_class_thresh(test_ens, class_thresh = "kap_max")
collect_class_thresh(test_ens)
\dontshow{\}) # examplesIf}
}
\keyword{predict}
