% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_colors.R
\name{get_colors}
\alias{get_colors}
\title{Get colors from Chinese colors dataset or palettes}
\usage{
get_colors(..., palettes = NULL)
}
\arguments{
\item{...}{One or more search values.
Can be palette names, color names (pinyin or Chinese), numbers, or hex codes.
If NULL, using all Chinese colors.}

\item{palettes}{Optional. A named list of palettes to search in.
If \code{NULL} (default), searches in all available palettes.}
}
\value{
A data frame with class \code{colors} containing matching color information.
The result is automatically printed using \code{\link[=print.colors]{print.colors()}}.
}
\description{
Search for colors in the Chinese colors dataset and all available palettes.
This function can search by palette names, color names (pinyin or Chinese), numbers, or hex codes.
It automatically searches in all palettes and reports which palette(s) contain the found colors.
}
\examples{
get_colors("Paired")

get_colors("#FF7F00")

get_colors("pinlan")
get_colors(44)
get_colors("#2B73AF")

get_colors("cyan", palettes = "ChineseSet64")
}
\seealso{
\link{chinese_colors} for the dataset of Chinese traditional colors.
\link{get_chinese_palettes} for getting Chinese color palettes.
\link{ChineseColors} for the ChineseColors object.
}
