#' Get the next SQUID (or SQUIDs)
#'
#' @param x The SQUID or SQUIDs to follow (`follow` in the [squids::squids()]
#' function).
#' @param n The number of following SQUIDs you want
#' @inheritParams squids
#'
#' @export next_squid
#' @export next_squids
#' @aliases next_squid next_squids
#' @returns One or more SQUIDs
#'
#' @examples exampleSQUID <-
#'   squids::squids(1);
#'
#' exampleSQUID;
#'
#' squids::next_squid(exampleSQUID);
#'
#' ### Or for multiple SQUIDs
#' exampleSQUIDs <-
#'   squids::squids(5);
#'
#' exampleSQUIDs;
#'
#' squids::next_squids(exampleSQUIDs, 3);
next_squid <- next_squids <- function(x,
                                      n = 1,
                                      followBy = NULL) {
  return(
    squids::squids(
      x = n,
      follow = x,
      followBy = followBy
    )
  );
}
