% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sar_threshold.R
\name{logLik.thresholdInt}
\alias{logLik.thresholdInt}
\title{Extract Log-Likelihood for the thresholdInt class}
\usage{
\method{logLik}{thresholdInt}(object, ...)
}
\arguments{
\item{object}{Threshold model fits of class \code{thresholdInt}.}

\item{...}{Additional arguments.}
}
\value{
Returns an object of class \code{logLik}, where the
  "df" (degrees of freedom) attribute has been adjusted to
  account for the breakpoint search. See
  \code{\link[stats]{logLik}} for more details on objects of
  class \code{logLik}.
}
\description{
Extract the log-likelihood of sar_threshold
  model fits, adjusting the number of parameters to account
  for the breakpoint search. This is a method function for the 
  \code{\link[stats]{logLik}} generic.
}
\details{
There has been considerable debate regarding the
  number of parameters that are included in different
  piecewise models. Here (and thus in our calculation of AIC,
  AICc, BIC etc) we consider ContOne to have five parameters,
  ZslopeOne - 4, DiscOne - 6, ContTwo - 7, ZslopeTwo - 6,
  DiscTwo
  - 9. This function
  adjusts the degrees of freedom associated with the log
  likelihood to match the number of parameters listed above.
  See Matthews & Rigal (2021) for more information.
}
\examples{
data(aegean2)
a2 <- aegean2[1:168,]
fitT <- sar_threshold(data = a2, mod = c("ContOne", "DiscOne"), 
interval = 0.1, non_th_models = TRUE, logAxes = "area", logT = log10)
logLik(fitT[[1]][[1]])
}
\references{
Matthews, T.J. & Rigal, F. (2021) Thresholds and
  the species–area relationship: a set of functions for
  fitting, evaluating and plotting a range of commonly used
  piecewise models. Frontiers of Biogeography, 13, e49404.
}
\author{
Thomas J. Matthews
}
