% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_compatibility.R
\name{insert_rrow}
\alias{insert_rrow}
\title{Insert \code{rrow}s at (before) a specific location}
\usage{
insert_rrow(tbl, rrow, at = 1, ascontent = FALSE)
}
\arguments{
\item{tbl}{(\code{VTableTree})\cr a \code{rtable} object.}

\item{rrow}{(\code{TableRow})\cr an \code{rrow} to append to \code{tbl}.}

\item{at}{(\code{integer(1)})\cr position into which to put the \code{rrow}, defaults to beginning (i.e. row 1).}

\item{ascontent}{(\code{flag})\cr currently ignored.}
}
\value{
A \code{TableTree} of the same specific class as \code{tbl}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\details{
This function is deprecated and will be removed in a future release of \code{rtables}. Please use
\code{\link[=insert_row_at_path]{insert_row_at_path()}} or \code{\link[=label_at_path]{label_at_path()}} instead.
}
\note{
Label rows (i.e. a row with no data values, only a \code{row.name}) can only be inserted at positions which do
not already contain a label row when there is a non-trivial nested row structure in \code{tbl}.
}
\examples{
o <- options(warn = 0)
lyt <- basic_table() \%>\%
  split_cols_by("Species") \%>\%
  analyze("Sepal.Length")

tbl <- build_table(lyt, iris)

insert_rrow(tbl, rrow("Hello World"))
insert_rrow(tbl, rrow("Hello World"), at = 2)

lyt2 <- basic_table() \%>\%
  split_cols_by("Species") \%>\%
  split_rows_by("Species") \%>\%
  analyze("Sepal.Length")

tbl2 <- build_table(lyt2, iris)

insert_rrow(tbl2, rrow("Hello World"))
insert_rrow(tbl2, rrow("Hello World"), at = 2)
insert_rrow(tbl2, rrow("Hello World"), at = 4)

insert_rrow(tbl2, rrow("new row", 5, 6, 7))

insert_rrow(tbl2, rrow("new row", 5, 6, 7), at = 3)

options(o)

}
