% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drc_4p_plot.R
\name{drc_4p_plot}
\alias{drc_4p_plot}
\title{Plotting of four-parameter dose response curves}
\usage{
drc_4p_plot(
  data,
  grouping,
  response,
  dose,
  targets,
  unit = "uM",
  y_axis_name = "Response",
  facet_title_size = 15,
  facet = TRUE,
  scales = "free",
  x_axis_scale_log10 = TRUE,
  x_axis_limits = c(NA, NA),
  colours = NULL,
  export = FALSE,
  export_height = 25,
  export_width = 30,
  export_name = "dose-response_curves"
)
}
\arguments{
\item{data}{a data frame that is obtained by calling the \code{fit_drc_4p} function.}

\item{grouping}{a character column in the \code{data} data frame that contains the precursor,
peptide or protein identifiers.}

\item{response}{a numeric column in a nested data frame called \code{plot_points} that is part
of the \code{data} data frame. This column contains the response values, e.g. log2 transformed
intensities.}

\item{dose}{a numeric column in a nested data frame called \code{plot_points} that is part
of the \code{data} data frame. This column contains the dose values, e.g. the treatment
concentrations.}

\item{targets}{a character vector that specifies the names of the precursors, peptides or
proteins (depending on \code{grouping}) that should be plotted. This can also be \code{"all"}
if plots for all curve fits should be created.}

\item{unit}{a character value specifying the unit of the concentration.}

\item{y_axis_name}{a character value specifying the name of the y-axis of the plot.}

\item{facet_title_size}{a numeric value that specifies the size of the facet title. Default is 15.}

\item{facet}{a logical value that indicates if plots should be summarised into facets of 20
plots. This is recommended for many plots.}

\item{scales}{a character value that specifies if the scales in faceted plots (if more than one
target was provided) should be \code{"free"} or \code{"fixed"}.}

\item{x_axis_scale_log10}{a logical value that indicates if the x-axis scale should be log10
transformed.}

\item{x_axis_limits}{a numeric vector of length 2, defining the lower and upper x-axis limit. The
default is \code{c(NA, NA)}, meaning the limits are not defined by the user but by the data.}

\item{colours}{a character vector containing at least three colours. The first is used for the points,
the second for the confidence interval and the third for the curve. By default the first two
protti colours are used for the points and confidence interval and the curve is black.}

\item{export}{a logical value that indicates if plots should be exported as PDF. The output
directory will be the current working directory. The name of the file can be chosen using the
\code{export_name} argument. If only one target is selected and \code{export = TRUE},
the plot is exported and in addition returned in R.}

\item{export_height}{a numeric value that specifies the plot height in inches for an exported plot.
The default is \code{25}. For a non-facet plot we recommend using 8.}

\item{export_width}{a numeric value that specifies the plot height in inches for an exported plot.
The default is \code{30}. For a non-facet plot we recommend using 12.}

\item{export_name}{a character value providing the name of the exported file if
\code{export = TRUE}.}
}
\value{
If \code{targets = "all"} a list containing plots for every unique identifier in the
\code{grouping} variable is created. Otherwise a plot for the specified targets is created with
maximally 20 facets.
}
\description{
Function for plotting four-parameter dose response curves for each group (precursor, peptide or
protein), based on output from \code{fit_drc_4p} function.
}
\examples{
\donttest{
set.seed(123) # Makes example reproducible

# Create example data
data <- create_synthetic_data(
  n_proteins = 2,
  frac_change = 1,
  n_replicates = 3,
  n_conditions = 8,
  method = "dose_response",
  concentrations = c(0, 1, 10, 50, 100, 500, 1000, 5000),
  additional_metadata = FALSE
)

# Perform dose response curve fit
drc_fit <- fit_drc_4p(
  data = data,
  sample = sample,
  grouping = peptide,
  response = peptide_intensity_missing,
  dose = concentration,
  retain_columns = c(protein)
)

str(drc_fit)

# Plot dose response curves
if (!is.null(drc_fit)) {
  drc_4p_plot(
    data = drc_fit,
    grouping = peptide,
    response = peptide_intensity_missing,
    dose = concentration,
    targets = c("peptide_2_1", "peptide_2_3"),
    unit = "pM"
  )
}
}
}
