% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_regions.R
\name{ps_regions}
\alias{ps_regions}
\title{Cluster analysis to identify phylogenetic regions}
\usage{
ps_regions(ps, k = 5, method = "average", endemism = FALSE, normalize = TRUE)
}
\arguments{
\item{ps}{A \code{phylospatial} object. If \code{method} is anything other than \code{"kmeans"}, it must contain a
\code{dissim} component generated by \link{ps_add_dissim}.}

\item{k}{Number of spatial clusters to divide the region into (positive integer). See \link{ps_regions_eval} to
help choose a value of k by comparing the variance explained by different numbers of regions.}

\item{method}{Clustering method. Options include all methods listed under \link[stats]{hclust}, and \code{"kmeans"}.
If \code{"kmeans"} is selected, the \code{dissim} component of \code{ps} is ignored.}

\item{endemism}{Logical indicating whether community values should be divided by column totals (taxon range sizes)
to derive endemism. Only used if \code{method = "kmeans"}; in other cases this information should instead be
supplied to \link{ps_add_dissim}.}

\item{normalize}{Logical indicating whether community values should be divided by row totals (community sums). If \code{TRUE},
dissimilarity is based on proportional community composition. This happens after endemism is derived. Only used if
\code{method = "kmeans"}; in other cases this information should instead be supplied to \link{ps_add_dissim}.}
}
\value{
A raster or matrix with an integer indicating which of the \code{k} regions each site belongs to.
}
\description{
Perform a clustering analysis that categorizes sites into biogeographic regions based on phylogenetic community
compositional similarity.
}
\examples{
ps <- ps_simulate()

# using kmeans clustering algorithm
terra::plot(ps_regions(ps, method = "kmeans"))

# to use a hierarchical clustering method, first we have to `ps_add_dissim()`
terra::plot(ps_regions(ps_add_dissim(ps), k = 7, method = "average"))

}
\references{
Daru, B. H., Elliott, T. L., Park, D. S., & Davies, T. J. (2017). Understanding the processes underpinning
patterns of phylogenetic regionalization. Trends in Ecology & Evolution, 32(11), 845-860.
}
