% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.agnes.R
\name{as.agnes}
\alias{as.agnes}
\title{Convert Objects to Class agnes, twins}
\usage{
as.agnes(x, ...)
}
\arguments{
\item{x}{The "nomclust" object containing components "dend" and "prox".}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The function returns an object of class "agnes, twins".
\cr
}
\description{
Converts objects of the class "nomclust" to the class "agnes, twins".
}
\examples{
# sample data
data(data20)

# creating an object with results of hierarchical clustering of 
hca.object <- nomclust(data20, measure = "lin", method = "average",
 clu.high = 5, prox = TRUE)

# nomclust plot
plot(hca.object)

# obtaining the agnes, twins object
hca.object.agnes <- as.agnes(hca.object)

# agnes plot
plot(hca.object.agnes)

# obtaining the hclust object
hca.object.hclust <- as.hclust(hca.object)

# hclust plot
plot(hca.object.hclust)

}
\seealso{
\code{\link[cluster]{agnes}}, \code{\link[stats]{as.hclust}} and \code{\link[stats]{hclust}}.
}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
