% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_dglm.R
\name{mc_dglm}
\alias{mc_dglm}
\title{Double Generalized Linear Models Structure}
\source{
Bonat, W. H. (2018). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, 84(4):1--30.
}
\usage{
mc_dglm(formula, id, data)
}
\arguments{
\item{formula}{a formula spefying the components of the covariance
structure.}

\item{id}{name of the column (string) containing the subject index.
(If ts is not repeated measures, use id = 1 for all observations).}

\item{data}{data set.}
}
\value{
A list containing diagonal matrices with entries defined by the
  covariates assumed to describe the matrix linear predictor.
  Each matrix corresponds to one component of the covariance model and
  is intended to be supplied to the \code{matrix_pred} argument of
  \code{\link{mcglm}}.
}
\description{
The function \code{mc_dglm} builds the components
of the matrix linear predictor used for fitting double generalized
linear models.
}
\seealso{
\code{mc_id}, \code{mc_dist}, \code{mc_ma}, \code{mc_rw}
\cr and \code{mc_mixed}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
