% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/G_ali.R
\name{G_ali}
\alias{G_ali}
\title{Albedo-reflected irradiance on Mars inclined surface}
\usage{
G_ali(
  Ls,
  phi,
  longitude,
  Ts,
  z = Z(Ls = Ls, Ts = Ts, phi = phi),
  tau,
  al = albedo(latitude = phi, longitude = longitude, tau = tau),
  beta
)
}
\arguments{
\item{Ls}{Areocentric longitude [deg]}

\item{phi}{Planetary latitude [deg]}

\item{longitude}{Planetary longitude [deg]}

\item{Ts}{Solar time [h]}

\item{z}{Sun zenith angle [deg]. If not provided, calculated from Ls, phi, and Ts}

\item{tau}{Atmospheric optical depth (dimensionless)}

\item{al}{Surface albedo (dimensionless, 0-1). If not provided, calculated from latitude, longitude, and tau}

\item{beta}{Surface tilt/slope angle from horizontal [deg]}
}
\value{
Albedo-reflected irradiance on inclined surface [W/m²]
}
\description{
Calculates the solar irradiance reflected from the Martian surface (ground-reflected radiation)
incident on an inclined surface. Accounts for the view factor of the ground from the tilted surface.
}
