% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp-get-hydrobasin.R
\encoding{UTF-8}
\name{esp_get_hydrobasin}
\alias{esp_get_hydrobasin}
\title{River basin districts of Spain - SIANE}
\source{
CartoBase ANE provided by Instituto Geografico Nacional (IGN),
\url{http://www.ign.es/web/ign/portal}. Years available are 2005 up to today.

Copyright:
\url{https://centrodedescargas.cnig.es/CentroDescargas/cartobase-ane}

It's necessary to always acknowledge authorship using the following formulas:
\enumerate{
\item When the original digital product is not modified or altered, it can
be expressed in one of the following ways:
\itemize{
\item CartoBase ANE 2006-2024 CC-BY 4.0 ign.es
\item CartoBase ANE 2006-2024 CC-BY 4.0 Instituto Geográfico Nacional
}
\item When a new product is generated:
}
\itemize{
\item Obra derivada de CartoBase ANE 2006-2024 CC-BY 4.0 ign.es
}

Data distributed via a custom CDN, see
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata}.
}
\usage{
esp_get_hydrobasin(
  epsg = 4258,
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  resolution = c(3, 6.5, 10),
  domain = c("land", "landsea")
)
}
\arguments{
\item{epsg}{character string or number. Projection of the map: 4-digit
\href{https://epsg.io/}{EPSG code}. One of:
\itemize{
\item \code{"4258"}: \href{https://epsg.io/4258}{ETRS89}
\item \code{"4326"}: \href{https://epsg.io/4326}{WGS84}.
\item \code{"3035"}: \href{https://epsg.io/3035}{ETRS89 / ETRS-LAEA}.
\item \code{"3857"}: \href{https://epsg.io/3857}{Pseudo-Mercator}.
}}

\item{cache}{logical. Whether to do caching. Default is \code{TRUE}. See
\strong{Caching strategies} section in \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.}

\item{update_cache}{logical. Should the cached file be refreshed? Default
is \code{FALSE}. When set to \code{TRUE}, it will force a new download.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{resolution}{character string or number. Resolution of the geospatial
data. One of:
\itemize{
\item "10": 1:10 million.
\item "6.5": 1:6.5 million.
\item "3": 1:3 million.
}}

\item{domain}{character string. Type of river basin district. Possible
values are \code{"land"}, including only the groundwaters area or \code{"landsea"},
groundwaters and coastal waters.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
River basin districts are the areas of land and sea, made up of one or more
neighbouring river basins together with their associated groundwaters and
coastal waters.
}
\details{
Metadata available on
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata/}.
}
\examples{
\dontshow{if (esp_check_access()) withAutoprint(\{ # examplesIf}
\donttest{
hydroland <- esp_get_hydrobasin(domain = "land")
hydrolandsea <- esp_get_hydrobasin(domain = "landsea")

library(ggplot2)


ggplot(hydroland) +
  geom_sf(data = hydrolandsea, fill = "skyblue4", alpha = .4) +
  geom_sf(fill = "skyblue", alpha = .5) +
  geom_sf_text(aes(label = rotulo),
    size = 2, check_overlap = TRUE,
    fontface = "bold",
    family = "serif"
  ) +
  coord_sf(
    crs = 3857,
    xlim = c(-9.5, 4.5),
    ylim = c(35, 44)
  ) +
  theme_void()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other natural features:
\code{\link{esp_get_hypsobath}()},
\code{\link{esp_get_landwater}}
}
\concept{natural}
