% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whit_loggit.R
\name{with_loggit}
\alias{with_loggit}
\title{Log any expressions}
\usage{
with_loggit(
  exp,
  logfile = get_logfile(),
  echo = get_echo(),
  log_level = get_log_level()
)
}
\arguments{
\item{exp}{An \code{expression} to evaluate.}

\item{logfile}{Path of log file to write to.}

\item{echo}{Should the log entry (json) be echoed to \code{stdout} as well?}

\item{log_level}{The log level to use.}
}
\value{
The result of the expression.
}
\description{
Log code without having to explicitly use the \code{loggit2} handlers.
This is particularly useful for code that cannot be customized, e.g. from third-party packages.
}
\details{
If \code{loggit2} handlers are already used in the expression, this can lead to conditions being logged
twice (in the same or different files).
}
\examples{
\dontrun{
 x <- with_loggit(5L + 5L)

 with_loggit(base::message("Test log message"))

 with_loggit(base::warning("Test log message"), echo = FALSE, logfile = "my_log.log")

 x <- with_loggit({
    y <- 5L
    base::message("Test log message")
    base::warning("Test log message")
    1L + y
 })
}

}
