% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landpred.R
\name{optimize_bandwidth}
\alias{optimize_bandwidth}
\title{Optimize Bandwidth for Continuous Landpred Models}
\usage{
optimize_bandwidth(
  landpred_obj,
  t0,
  tau,
  lower = 0.05,
  upper = 5,
  transform = identity,
  reps = 50,
  train_prop = 0.66
)
}
\arguments{
\item{landpred_obj}{A landpred object.}

\item{t0}{The landmark time.}

\item{tau}{The prediction window.}

\item{lower}{Lower bound for bandwidth search.}

\item{upper}{Upper bound for bandwidth search.}

\item{transform}{Transformation function for the short-term event (e.g., log). Default is identity.}

\item{reps}{Number of cross-validation repetitions. Default is 50.}

\item{train_prop}{Proportion of data used for training in each fold. Default is 0.66.}
}
\value{
The optimal bandwidth.
}
\description{
Selects the optimal bandwidth by minimizing the Mean Squared Error (MSE) using cross-validation.
}
