% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_functions.R
\name{make_combo_splitfun}
\alias{make_combo_splitfun}
\title{Split Function Helper}
\usage{
make_combo_splitfun(nm, label = nm, levels = NULL, rm_other_facets = TRUE)
}
\arguments{
\item{nm}{(\code{character})\cr Name/virtual 'value' for the new facet.}

\item{label}{(\code{character})\cr Label for the new facet.}

\item{levels}{(\code{character} or NULL)\cr The levels to combine into the new facet,
or NULL, indicating the facet should include all incoming data.}

\item{rm_other_facets}{(\code{logical})\cr Should facets other than the newly
created one be removed. Defaults to \code{TRUE}.}
}
\value{
Function usable directly as a split function.
}
\description{
A function which aids the construction for users to create their own split function for combined columns.
}
\examples{
aesevall_spf <- make_combo_splitfun(nm = "AESEV_ALL", label = "Any AE", levels = NULL)
}
