% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_print_journal.R
\name{format_lancet_clu}
\alias{format_lancet_clu}
\title{Format central, lower, upper value triplets for Lancet journal presentation}
\usage{
format_lancet_clu(central, lower, upper, metric, rate_unit = NULL, mag = NULL)
}
\arguments{
\item{central}{[num] central, point_estimate value vector}

\item{lower}{[num] lower bound vector}

\item{upper}{[num] upper bound vector}

\item{metric}{[chr c(prop, pp, count, rate)] metric - proportion,
percentage point, count, or rate}

\item{rate_unit}{[chr: default NULL] rate unit label (required when metric = 'rate')}

\item{mag}{[chr: default NULL] magnitude override - see set_magnitude()
- For props/pp: "as-is" (no scaling, use values as provided)
- For counts: "t" (thousand), "m" (million), "b" (billion)
- For rates: "per10", "per100", "per1k", ..., "per10b"
- Examples: "deaths", "cases", "events", "births"}
}
\value{
[chr] formatted string vector
}
\description{
Format central, lower, upper value triplets for Lancet journal presentation
}
\examples{
format_lancet_clu(
   central  = c(0.994, -0.994)
   , lower  = c(0.984, -0.998)
   , upper  = c(0.998, -0.984)
   , metric = "prop"
)

# Rate example with Lancet formatting
format_lancet_clu(
  central   = 0.0000123,
  lower     = 0.0000098,
  upper     = 0.0000152,
  metric    = "rate",
  rate_unit = "deaths"
)
}
\seealso{
Other styled_formats: 
\code{\link{format_journal_clu}()},
\code{\link{format_journal_df}()},
\code{\link{format_lancet_df}()},
\code{\link{format_metric_cols}()},
\code{\link{format_nature_clu}()},
\code{\link{format_nature_df}()},
\code{\link{fround_clu_triplet}()},
\code{\link{new_style}()}
}
\concept{styled_formats}
