% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_helper_functions.R
\name{summarize_TBclass}
\alias{summarize_TBclass}
\title{Summarize TreeBagger Classifier Results}
\usage{
summarize_TBclass(classfile, adhocthresh = NULL)
}
\arguments{
\item{classfile}{Character string specifying the path to the TreeBagger classifier result file (\code{.mat} format).}

\item{adhocthresh}{Numeric vector specifying the adhoc thresholds for each class. If NULL (default), no adhoc thresholding is applied.
If a single numeric value is provided, it is applied to all classes.}
}
\value{
A list containing three elements:
\item{classcount}{Numeric vector of counts for each class based on the winning class assignment.}
\item{classcount_above_optthresh}{Numeric vector of counts for each class above the optimal threshold for maximum accuracy.}
\item{classcount_above_adhocthresh}{Numeric vector of counts for each class above the specified adhoc thresholds (if provided).}
}
\description{
This function reads a TreeBagger classifier result file (\code{.mat} format) and summarizes
the number of targets in each class based on the classification scores and thresholds.
}
