% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_election.R
\name{simulate_election}
\alias{simulate_election}
\title{Function to simulate a full election in a single district}
\usage{
simulate_election(
  voters = NULL,
  parties = NULL,
  cands = NULL,
  nominated = NULL,
  nvoters = 3000,
  nparties = 5,
  nvotes = 1,
  M = 5,
  rank_cand = TRUE,
  strategic = TRUE,
  strategic_error = 0.05,
  who_ranks = c("parties", "voters", "none"),
  gamma_val = NULL,
  gamma_rank = 1,
  elec_fun_name = "dhondt",
  ballot_type = "open",
  primary = FALSE,
  two_round = FALSE,
  pool_level = c("party_list", "party", "candidate"),
  ranked_vote = FALSE,
  free_vote = FALSE,
  max_cand = 0,
  threshold = 0,
  lists_per_party = 1,
  seed = 123,
  elec_results_only = FALSE,
  multiplier = 1,
  system_name,
  ...
)
}
\arguments{
\item{voters}{Optional vector of voter positions in 1d ideological space.}

\item{parties}{Optional vector of party positions in 1d ideological space. Maximum of 10 parties allowed.}

\item{cands}{Optional matrix with three columns: candidate 1d ideological position, unique numerical candidate ID, and positive numerical candidate valence}

\item{nominated}{Optional data.frame with five variables: \code{rank} (candidate ranking in the party list); \code{candidate} (numeric candidate ID); \code{pos} (1d ideological position of candidate); \code{list} (numeric list ID; equal to 1, unless parties are allowed to have multiple lists); \code{party} (numeric party ID).}

\item{nvoters}{Number of voters; defaults to 3,000.}

\item{nparties}{Number of parties; defaults to 5; maximum allowable: 10.}

\item{nvotes}{Number of votes per voter; defaults to 1. Can also take on special values \code{0} (which then is internally replaced by the district magnitude) and \code{-1} (which is then internally replaced by 1 fewer vote than the district magnitude).}

\item{M}{District magnitude; defaults to 5.}

\item{rank_cand}{Boolean: should candidates be ranked on the party list? Defaults to \code{TRUE}.}

\item{strategic}{Boolean: do parties and voters behave strategically? Defaults to \code{TRUE}.}

\item{strategic_error}{Numeric probability with which strategic actors fail to choose the optimal alternative.}

\item{who_ranks}{Character actor who arranges party lists, one of \code{parties}, \code{voters},\code{none}; defaults to \code{parties}.}

\item{gamma_val}{Numeric weight assigned to the valence component of voters' utility function.}

\item{gamma_rank}{Numeric weight assigned to the candidate ranking on the party list when computing the voter's utility.}

\item{elec_fun_name}{Name of function implementing electoral system formula.}

\item{ballot_type}{Character string indicating type of ballot, one of \code{open},\code{closed}, or \code{flexible}; defaults to \code{open}.}

\item{primary}{Boolean: should a primary election be conducted? Defaults to \code{FALSE}.}

\item{two_round}{Boolean: should a second election round be conducted? Defaults to \code{FALSE}.}

\item{pool_level}{Character level at which votes are pooled, one of \code{party_list} (or sub-party list),\code{party}, or \code{candidate}. Defaults to \code{party_list}}

\item{ranked_vote}{Boolean: Do voters cast a ranked vote? Defaults to \code{FALSE}.}

\item{free_vote}{Boolean: If voters can cast multiple votes, can the be for candidates in different parties? Defaults to \code{FALSE}.}

\item{max_cand}{Numeric maximum number of candidates running in a party list; defaults to 0, which is internally interpreted as the district magnitude.}

\item{threshold}{Numerical legal electoral threshold; defaults to 0 (i.e., no threshold).}

\item{lists_per_party}{Integer allowed number of lists per party; defaults to 1.}

\item{seed}{Random number generator seed; defaults to 123.}

\item{elec_results_only}{Boolean: Should function return ancillary information on election, or just election results? Defaults to \code{FALSE}.}

\item{multiplier}{Numeric factor by which to multiply the votes cast by voters with the same ideological position; defaults to 1.}

\item{system_name}{Character name of electoral system used, one of 'AV', 'BC', 'STV', 'MNTV', 'LV', 'PR', or 'SMDP'}

\item{...}{Additional arguments passed to \code{elec_fun_name}.}
}
\value{
data.frame with the following variables (if \code{elec_results_only=FALSE},
otherwise, data.frame with candidate id's, positions, valences, votes obtained,
and whether they won a seat or not):
\describe{
\item{gamma_val}{See \code{Usage} above}
\item{epsilon}{Maximum acceptable ideological distance used in voters' utility function}
\item{hetero}{Measure of elected candidate heterogeneity}
\item{pers}{Average valence of elected candidates}
\item{lsq}{Least Squares measure of disproportionality}
\item{enp_v}{Effective number of electoral parties}
\item{enp_s}{Effective number of legislative parties}
\item{avg_dist}{Average distance between elected candidates and voters}
\item{var_elect}{Variance of ideological positions of elected candidates}
\item{avg_vote_util}{Average utility of voters w.r.t. candidates they voted for}
\item{avg_elect_util}{Average utility of voters w.r.t. elected candidates}
\item{sample_parties}{Parties that initially could have entered the election}
\item{ran_parties}{Parties that decided to enter the election}
}
}
\description{
The function runs a complete election in a single district,
using the simulation framework described in detail in
Chapter 4 of Crisp et al. 2024.
}
\examples{
# Simulate a PR (D'Hondt) election with 3 parties, 5 candidates per party,
# 100 voters, and a district magnitude of 2, allowing for strategic voting

simulate_election(parties = c(-1, 0, 1),
                  nvoters = 100,
                  M = 2,
                  strategic = TRUE,
                  elec_fun_name = "dhondt",
                  system_name = "PR")
}
