% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_iii.R
\name{predict_iii}
\alias{predict_iii}
\title{Predict II Score for a given set of electoral rule configurations}
\usage{
predict_iii(
  data,
  score = c("TDE", "AP"),
  district_level = TRUE,
  return_avg = TRUE
)
}
\arguments{
\item{data}{A data.frame containing the following variables: \code{ballot_type} (factor),
\code{pool_level} (factor), \code{votes_per_voter} (factor), \code{M} (numeric), \code{threshold} (numeric), and \code{formula} (factor). See \code{\link[=simulate_election]{simulate_election()}} for more details.}

\item{score}{Character string indicating type of score to predict; one of \code{TDE} (default) or \code{AP}.}

\item{district_level}{Boolean: Should district level, or country level models be used? If \code{TRUE} (default), the
function uses district level models, which are more accurate for district-level electoral systems. If \code{FALSE}, the
function uses country-level models, which are more accurate for country-level electoral systems.}

\item{return_avg}{Boolean: Should the average score across imputed models be returned? The original models
were trained on millions of simulated elections, with intermediate values for some parameters interpolated using
5 multiple imputations. If \code{TRUE} (default), the function returns the average score across all imputations.
If \code{FALSE}, the function returns a list of scores.}
}
\value{
Predicted TDE or AP score for given electoral system
}
\description{
Predict II Score for a given set of electoral rule configurations
}
\examples{
## Create example data for PR system with closed party lists,
## magnitude 5, and Droop quota
new_system <- data.frame(ballot_type = as.factor("closed"),
                         pool_level = as.factor("party"),
                         votes_per_voter = as.factor("One"),
                         M = 5.0,
                         threshold = 0.05,
                         formula = as.factor("droop"))
predict_iii(data = new_system, score = "AP", district_level = FALSE)

}
