% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-table.R
\name{width}
\alias{width}
\alias{width<-}
\alias{set_width}
\title{Set the table width}
\usage{
width(ht)

width(ht) <- value

set_width(ht, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A number or string. Set to \code{NA} to reset to the default, which is \code{NA_real_}.}
}
\value{
\code{property()} returns the property value(s).
\code{set_property()} and \code{map_property()} return the modified huxtable.
}
\description{
\code{width()} sets the width of the entire table, while \code{\link[=col_width]{col_width()}} sets the
width of individual columns. A numeric width is treated as a proportion of
f the surrounding block width (HTML) or text width (LaTeX). A character width
must be a valid CSS or LaTeX dimension.
}
\examples{
set_width(jams, 0.8)

}
\seealso{
Other table measurements: 
\code{\link{col_width}()},
\code{\link{height}()},
\code{\link{row_height}()}
}
\concept{table measurements}
