% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restack-split.R
\name{split-across-down}
\alias{split-across-down}
\alias{split_across}
\alias{split_down}
\title{Split a huxtable into multiple huxtables}
\usage{
split_across(ht, after, height, headers = TRUE)

split_down(ht, after, width, headers = TRUE)
}
\arguments{
\item{ht}{A huxtable.}

\item{after}{Rows/columns after which to split. See \link{rowspecs} for details.
Note that \link[tidyselect:language]{tidyselect} semantics are allowed
in \code{split_down()} but not \code{split_across()}.}

\item{height, width}{Maximum height/width for the result.}

\item{headers}{Logical. Take account of header rows/columns?}
}
\value{
A list of huxtables.
}
\description{
These functions split a huxtable horizontally or vertically, and
return the new sub-tables in a list.
}
\details{
Only one of \code{after} and \code{width} or \code{height} must be given. If \code{width} or
\code{height} is given, the huxtable will be split by \code{\link[=col_width]{col_width()}} or
\code{\link[=row_height]{row_height()}}, which must be numeric with no \code{NA} values.

If \code{headers} is \code{TRUE}, all previous headers will be added to each
new table.
}
\examples{
ht <- as_hux(matrix(LETTERS[1:16], 4, 4))
ht <- set_all_borders(ht)
split_across(ht, after = 2)
split_down(ht, after = c(1, 3))

col_width(ht) <- c(0.15, 0.1, 0.25, 0.3)
split_down(ht, width = 0.3)

# split by column name:
split_down(jams, "Type")

# headers are repeated:
split_across(jams, 3)

}
\seealso{
\link{restack-across-down}
}
