% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_deprecated_schema.R
\name{check_deprecated_schema}
\alias{check_deprecated_schema}
\title{Check whether a config file is using a deprecated schema}
\usage{
check_deprecated_schema(
  config_version,
  config,
  valid_version = "v2.0.0",
  hubutils_version = "0.0.0.9010"
)
}
\arguments{
\item{config_version}{Character string of the schema version.}

\item{config}{List representation of config file.}

\item{valid_version}{Character string of minimum valid schema version.}

\item{hubutils_version}{The version of the hubUtils package in which deprecation of
the schema version below \code{valid_version} is introduced.}
}
\value{
Invisibly, \code{TRUE} if the schema version is deprecated, \code{FALSE} otherwise.
Primarily used for the side effect of issuing a lifecycle warning.
}
\description{
Function compares the current schema version in a config file to a valid version,
If config file version deprecated compared to valid version, the function
issues a lifecycle warning to prompt user to upgrade.
}
