% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/httkexamples-package.R
\docType{package}
\name{httkexamples-package}
\alias{httkexamples}
\alias{httkexamples-package}
\title{httkexamples: High-Throughput Toxicokinetics Examples}
\description{
High throughput toxicokinetics ("HTTK") is the combination of 1) chemical-specific in vitro measurements or in silico predictions and 2) generic mathematical models, to predict absorption, distribution, metabolism, and excretion by the body. HTTK methods have been described by Pearce et al. (2017) (\doi{10.18637/jss.v079.i04}) and Breen et al. (2021) (\doi{10.1080/17425255.2021.1935867}). Here we provide examples (vignettes) applying HTTK to solve various problems in bioinformatics, toxicology, and exposure science. In accordance with Davidson-Fritz et al. (2025) (\doi{10.1371/journal.pone.0321321}), whenever a new HTTK model is developed, the code to generate the figures evaluating that model is added as a new vignettte.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://chemicalinsights.ul.org/}
}

}
\author{
\strong{Maintainer}: John Wambaugh \email{john.wambaugh@UL.org} (\href{https://orcid.org/0000-0002-4024-534X}{ORCID})

Authors:
\itemize{
  \item Robert Pearce (\href{https://orcid.org/0000-0003-3168-4049}{ORCID})
  \item Caroline Ring \email{Ring.Caroline@epa.gov} (\href{https://orcid.org/0000-0002-0463-1251}{ORCID})
  \item Greg Honda \email{honda.gregory@epa.gov} (\href{https://orcid.org/0000-0001-7713-9850}{ORCID})
  \item Matt Linakis \email{MLINAKIS@ramboll.com} (\href{https://orcid.org/0000-0003-0526-2395}{ORCID})
  \item Dustin Kapraun \email{kapraun.dustin@epa.gov} (\href{https://orcid.org/0000-0001-5570-6383}{ORCID})
  \item Kimberly Truong \email{truong.kimberly@epa.gov} (\href{https://orcid.org/0000-0003-1716-1006}{ORCID})
  \item Meredith Scherer \email{Scherer.Meredith@epa.gov} (\href{https://orcid.org/0000-0002-9785-7363}{ORCID})
  \item Annabel Meade \email{aemeade7@gmail.com} (\href{https://orcid.org/0000-0002-5452-8797}{ORCID})
  \item Celia Schacht \email{Schacht.Celia@epa.gov} (\href{https://orcid.org/0000-0002-8131-513X}{ORCID})
}

Other contributors:
\itemize{
  \item Elaina Kenyon (\href{https://orcid.org/0000-0001-8781-2391}{ORCID}) [contributor]
}

}
\keyword{internal}
