% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long_to_seq.R
\name{long_to_seq}
\alias{long_to_seq}
\title{Transform a data frame from long format to a sequence obect}
\usage{
long_to_seq(
  data,
  id,
  time,
  outcome,
  alphabet = "auto",
  labels = "auto",
  cnames = "auto",
  cpal = "auto",
  missing.color = "#BBBBBB",
  ...
)
}
\arguments{
\item{data}{A data frame or a data frame extension (e.g. a tibble).}

\item{id}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}>\cr
Column containing individual ids}

\item{time}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}>\cr
Time variable}

\item{outcome}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}>\cr
Variable defining the status}

\item{alphabet}{Optional vector containing the alphabet (the list of all
possible states).
If \code{alphabet = "auto"} will be automatically determined from \code{outcome}.
If \code{outcome} is a labelled vector (\code{haven_labelled} class),
it will be derived from the value labels (using the values).
If \code{outcome} is a factor, the factor will be transformed to a numeric vector
with \code{\link[=as.integer]{as.integer()}} and the corresponding numeric values will be used as the
alphabet. In all other cases, will be equal to \code{NULL}
(see \code{\link[TraMineR:seqdef]{TraMineR::seqdef()}}).}

\item{labels}{An optional vector containing state labels used for graphics.
If \code{labels = "auto"} will be automatically determined from \code{outcome}.
If \code{outcome} is a labelled vector (\code{haven_labelled} class),
it will be derived from the value labels (using the labels).
If \code{outcome} is a factor, the levels of the factor will be used.
In all other cases, will be equal to \code{NULL}}

\item{cnames}{An optional vector containing names of the different time
points. If \code{cnames = "auto"}, it will use the observed values from \code{time}.}

\item{cpal}{An optional colour palette for representing the states in the
graphics. If \code{cpal = "auto"}, a palette will be generated with \code{\link[=safe_pal]{safe_pal()}}.}

\item{missing.color}{Alternative colour for representing missing values
inside the sequences.}

\item{...}{Additional arguments passed to \code{\link[TraMineR:seqdef]{TraMineR::seqdef()}}}
}
\value{
An object of class \code{stslist}.
}
\description{
Transform a data frame from long format to a sequence obect
}
\examples{
\dontshow{if (rlang::is_installed("TraMineR")) withAutoprint(\{ # examplesIf}
\donttest{
library(TraMineR)

# generating a data frame in long format
data("biofam")
d <-
  biofam |>
  dplyr::mutate(id_ind = rownames(biofam)) |>
  dplyr::select(id_ind, dplyr::starts_with("a")) |>
  tidyr::pivot_longer(
    cols = dplyr::starts_with("a"),
    names_to = "age",
    names_prefix = "a",
    values_to = "life_state"
  ) |>
  dplyr::mutate(
    age = as.integer(age),
    life_state2 = dplyr::case_when(
      life_state == 0 ~ "P",
      life_state == 1 ~ "L",
      life_state == 2 ~ "M",
      life_state == 3 ~ "LM",
      life_state == 4 ~ "C",
      life_state == 5 ~ "LC",
      life_state == 6 ~ "LMC",
      life_state == 7 ~ "D"
    )
  ) |>
  labelled::set_value_labels(
    life_state = c(
      "Parent" = 0,
      "Left" = 1,
      "Married" = 2,
      "Left & Married" = 3,
      "Child" = 4,
      "Left & Child" = 5,
      "Left & Married & Child" = 6,
      "Divorced" = 7
    ),
    life_state2 = c(
      "Parent" = "P",
      "Left" = "L",
      "Married" = "M",
      "Left & Married" = "LM",
      "Child" = "C",
      "Left & Child" = "LC",
      "Left & Married & Child" = "LMC",
      "Divorced" = "D"
    )
  ) |>
  dplyr::mutate(
    life_state3 = labelled::to_factor(life_state),
    life_state4 = unclass(life_state2)
  )

d |> long_to_seq(id = id_ind, time = age, outcome = life_state) |> head(10)
d |> long_to_seq(id = id_ind, time = age, outcome = life_state2) |> head(10)
d |> long_to_seq(id = id_ind, time = age, outcome = life_state3) |> head(10)
d |> long_to_seq(id = id_ind, time = age, outcome = life_state4) |> head(10)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[TraMineR:seqdef]{TraMineR::seqdef()}}
}
\keyword{manip}
