% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_effects.R
\name{plot.light_effects}
\alias{plot.light_effects}
\title{Visualize Multiple Types of Profiles Together}
\usage{
\method{plot}{light_effects}(
  x,
  use = c("response", "predicted", "pd"),
  zero_counts = TRUE,
  size_factor = 1,
  facet_scales = "free_x",
  facet_nrow = 1L,
  rotate_x = TRUE,
  show_points = TRUE,
  recode_labels = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class "light_effects".}

\item{use}{A vector of elements to show. Any subset of ("response", "predicted",
"pd", "ale") or "all". Defaults to all except "ale"}

\item{zero_counts}{Logical flag if 0 count levels should be shown on the x axis.}

\item{size_factor}{Factor used to enlarge default \code{size/linewidth} in
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}} and \code{\link[ggplot2:geom_path]{ggplot2::geom_line()}}.}

\item{facet_scales}{Scales argument passed to \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}.}

\item{facet_nrow}{Number of rows in \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}.}

\item{rotate_x}{Should x axis labels be rotated by 45 degrees?}

\item{show_points}{Should points be added to the line (default is \code{TRUE}).}

\item{recode_labels}{Named vector of curve labels. The names refer to the usual
labels, while the values are the desired labels, e.g.,
`c("partial dependence" = PDP", "ale" = "ALE").}

\item{...}{Further arguments passed to geoms.}
}
\value{
An object of class "ggplot".
}
\description{
Visualizes response-, prediction-, partial dependence, and/or ALE profiles
of a (multi-)flashlight with respect to a covariable \code{v}.
Different flashlights or a single flashlight with one "by" variable are separated
by a facet wrap.
}
\seealso{
\code{\link[=light_effects]{light_effects()}}, \code{\link[=plot_counts]{plot_counts()}}
}
