% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtjoin_semi.R
\name{dtjoin_semi}
\alias{dtjoin_semi}
\title{Semi-join of \code{DT} in a \code{DT[i]}-style join of data frame-like
objects}
\usage{
dtjoin_semi(
  .DT = NULL,
  .i = NULL,
  on,
  match.na = FALSE,
  mult = "all",
  mult.DT = "all",
  nomatch = NULL,
  nomatch.DT = NULL,
  select = NULL,
  do = !(is.null(.DT) && is.null(.i)),
  show = !do,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{.DT, .i}{\code{data.frame}-like objects (plain, \code{data.table}, tibble,
\code{sf}, \code{list}, etc.), or else both omitted for a mock join
statement with no data.}

\item{on}{A character vector of join predicates, e.g. \code{c("id", "col_DT
== col_i", "date < date", "cost <= budget")}, or else \code{NA} for a
natural join (an equality join on all same-named columns).}

\item{match.na}{If \code{TRUE}, allow equality matches between \code{NA}s or
\code{NaN}s. Default \code{FALSE}.}

\item{mult}{(as in \code{[.data.table}) When a row of \code{.i} has multiple
matching rows in \code{.DT}, which to accept. One of \code{"all"} (the
default), \code{"first"}, or \code{"last"}.}

\item{mult.DT}{Permitted for consistency with \code{dtjoin} but
has no effect on the resulting semi-join.}

\item{nomatch, nomatch.DT}{Permitted for consistency with \code{dtjoin} but
have no effect on the resulting semi-join.}

\item{select}{Character vector of columns of \code{.DT} to be selected.
\code{NULL} (the default) selects all columns. Join columns are always
selected.}

\item{do}{Whether to execute the join. Default is \code{TRUE} unless
\code{.DT} and \code{.i} are both omitted/\code{NULL}, in which case a mock
join statement is produced.}

\item{show}{Whether to print the code for the join to the console. Default is
the opposite of \code{do}. If \code{.DT} and \code{.i} are both
omitted/\code{NULL}, mock join code is displayed.}

\item{verbose}{(passed to \code{[.data.table}) Whether data.table should
print information to the console during execution. Default \code{FALSE}.}

\item{...}{Further arguments (for internal use).}
}
\value{
A \code{data.frame}, \code{data.table}, (grouped) tibble, \code{sf},
or \code{sf}-tibble, or else \code{NULL} if \code{do} is \code{FALSE}. See
Details.
}
\description{
Write (and optionally run) \pkg{data.table} code to return the semi-join of
\code{DT} (the rows of \code{DT} that join with \code{i}) using a
generalisation of \code{DT[i]} syntax.

The functions \code{\link{fjoin_left_semi}} and \code{\link{fjoin_right_semi}}
provide a more conventional interface that is recommended over
\code{dtjoin_semi} for most users and cases.
}
\details{
Details are as for \code{\link{dtjoin}} except for arguments controlling
the order and prefixing of output columns, which do not apply.
}
\examples{
# Mock joins

dtjoin_semi(on = "id")
dtjoin_semi(on = c("id", "date <= date"))
dtjoin_semi(on = c("id", "date <= date"), mult = "last")


}
\seealso{
See the package-level documentation \code{\link{fjoin}} for related
 functions.
}
