% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_volume.R
\name{sum_neighbors_vol}
\alias{sum_neighbors_vol}
\title{Sum of each voxel's neighbors}
\usage{
sum_neighbors_vol(arr, pad = 0)
}
\arguments{
\item{arr}{The 3D array.}

\item{pad}{In order to compute the sum, the array is temporarily padded along
each edge with the value of \code{pad}. \code{0} (default) will mean that
edge voxels reflect the sum of 3-5 neighbors whereas non-edge voxels reflect
the sum of 6 neighbors. An alternative is to use a value of \code{NA} so
that edge voxels are \code{NA}-valued because they did not have a complete
set of six neighbors. Perhaps another option is to use \code{mean(arr)}.}
}
\value{
An array with the same dimensions as \code{arr}. Each voxel value
will be the sum across the immediate neighbors. If \code{arr} was a logical
array, this value will be between 0 and 6.
}
\description{
For each voxel in a 3D logical or numeric array, sum the values of the six
neighboring voxels.
}
\details{
Diagonal voxels are not considered adjacent, i.e. the voxel at (0,0,0) is not
adjacent to the voxels at (1,1,0) or (1,1,1), although it is adjacent to
(1,0,0).
}
