% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{order_cat_b}
\alias{order_cat_b}
\title{Order Category B}
\usage{
order_cat_b(data, group, cat_b, group_colors, reverse_order = FALSE)
}
\arguments{
\item{data}{A data frame containing the variables.}

\item{group}{The name of the column representing the grouping variable.}

\item{cat_b}{The name of the column representing category B.}

\item{group_colors}{A named vector of colors for each group. The names correspond to group names.}

\item{reverse_order}{Reverse the ordering? Default is FALSE.}
}
\value{
A vector of category B labels ordered according to group and count.
}
\description{
Determines the ordering of category B based on the counts within each group, ordered by group and count.
}
\examples{
library(dplyr)
data <- data.frame(
  group = rep(c("G1", "G2"), each = 5),
  cat_b = sample(LETTERS[1:3], 10, replace = TRUE)
)
group_colors <- c("G1" = "red", "G2" = "blue")
order_cat_b(data, "group", "cat_b", group_colors)
}
