% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_oauth_content_credentials}
\alias{get_oauth_content_credentials}
\title{Perform an OAuth credential exchange to obtain a content-specific OAuth
access token.}
\usage{
get_oauth_content_credentials(
  connect,
  content_session_token = NULL,
  requested_token_type = NULL,
  audience = NULL
)
}
\arguments{
\item{connect}{A Connect R6 object.}

\item{content_session_token}{Optional. The content session token. This token
can only be obtained when the content is running on a Connect server. The
token identifies the service account integration previously configured by
the publisher on the Connect server. Defaults to the value from the
environment variable: \code{CONNECT_CONTENT_SESSION_TOKEN}}

\item{requested_token_type}{Optional. The requested token type. If unset,
will default to \code{urn:ietf:params:oauth:token-type:access_token}. Otherwise,
this can be set to \code{urn:ietf:params:aws:token-type:credentials} for AWS
integrations or \code{urn:posit:connect:api-key} for Connect API Key integrations.}

\item{audience}{Optional. The GUID of an OAuth integration associated with
this piece of content.}
}
\value{
The OAuth credential exchange response.
}
\description{
Perform an OAuth credential exchange to obtain a content-specific OAuth
access token.
}
\details{
Please see https://docs.posit.co/connect/user/oauth-integrations/#obtaining-a-service-account-oauth-access-token
for more information.
}
\examples{
\dontrun{
library(connectapi)
library(plumber)
client <- connect()

#* @get /do
function(req) {
  credentials <- get_oauth_content_credentials(client)

  # ... do something with `credentials$access_token` ...

  "done"
}
}

}
\seealso{
\code{\link[=get_integrations]{get_integrations()}}, \code{\link[=get_oauth_credentials]{get_oauth_credentials()}}
}
