\name{truelove_witts_severity_index}
\alias{truelove_witts_severity_index}
\title{
Truelove and Witts Severity Index for Ulcerative Colitis
}
\description{
Calculates the Truelove and Witts Severity Index to classify the severity of an Ulcerative Colitis flare. The classification is based on six criteria: stool frequency, rectal bleeding, temperature, pulse, hemoglobin, and ESR.
}
\usage{
truelove_witts_severity_index(bowel_movements_per_day, rectal_bleeding,
                              temperature_c, heart_rate, hemoglobin_g_dl, esr)
}
\arguments{
  \item{bowel_movements_per_day}{
Numeric. Number of bowel movements per day.
}
  \item{rectal_bleeding}{
String. Presence of blood in stool. Options: "none" (small/none), "intermittent", "frequent_continuous" (visible blood).
}
  \item{temperature_c}{
Numeric. Body temperature in degrees Celsius. (> 37.5 C is a severe criterion).
}
  \item{heart_rate}{
Numeric. Pulse rate in beats per minute. (> 90 bpm is a severe criterion).
}
  \item{hemoglobin_g_dl}{
Numeric. Hemoglobin level in g/dL. (<= 10.5 g/dL is a severe criterion).
}
  \item{esr}{
Numeric. Erythrocyte Sedimentation Rate in mm/hr. (> 30 mm/hr is a severe criterion).
}
}
\details{
Classification logic:
- **Severe**: >= 6 bloody stools/day AND at least one sign of systemic toxicity (Temp > 37.5, HR > 90, Hgb <= 10.5, or ESR > 30).
- **Mild**: < 4 stools/day, with no or intermittent bleeding, and normal vital signs/labs.
- **Moderate**: Intermediate between Mild and Severe (e.g., > 4 stools but not meeting severe criteria).
}
\value{
A list containing:
\item{Severity_Index}{The severity classification (Mild, Moderate, Severe).}
}
\references{
Truelove SC, Witts LJ. Cortisone in ulcerative colitis; final report on a therapeutic trial. Br Med J. 1955;2(4947):1041-1048. doi:10.1136/bmj.2.4947.1041
}
\examples{

# Example 1: Severe Colitis
# 8 stools, frequent blood, HR 100, Temp 38
truelove_witts_severity_index(8, "frequent_continuous", 38.0, 100, 11.0, 25)

# Example 2: Mild Colitis
# 3 stools, intermittent blood, normal vitals/labs
truelove_witts_severity_index(3, "intermittent", 37.0, 70, 14.0, 10)
}
