\name{rome_iv_biliary_pain_criteria}
\alias{rome_iv_biliary_pain_criteria}
\title{
Rome IV Diagnostic Criteria for Functional Biliary Pain
}
\description{
Evaluates the **Rome IV criteria** for diagnosing **Functional Biliary Pain**. This diagnosis is a prerequisite for diagnosing Functional Gallbladder Disorder or Functional Sphincter of Oddi Disorder, requiring recurrent pain episodes that meet specific criteria for location, severity, and course.
}
\usage{
rome_iv_biliary_pain_criteria(location, severity, course, other_pain_excluded,
                              normal_imaging, not_explained_by_other_condition,
                              symptom_onset_ge_6_months, symptoms_active_last_3_months)
}
\arguments{
  \item{location}{
String. Pain location: "epigastrium", "ruq" (right upper quadrant), or "both".
}
  \item{severity}{
Numeric (0 or 1). Is the pain severe enough to interrupt daily activities or lead to an emergency room visit? (1 = Yes).
}
  \item{course}{
String. Pain course: "bouts" (rapidly builds up/subsides) or "steady" (pain plateau).
}
  \item{other_pain_excluded}{
Numeric (0 or 1). Does the pain radiate to the back or shoulder, which suggests other causes? (1 = Yes). Note: This input refers to the exclusion of non-biliary patterns.
}
  \item{normal_imaging}{
Numeric (0 or 1). Has imaging (e.g., ultrasound) excluded gallstones and other structural pathology? (1 = Yes).
}
  \item{not_explained_by_other_condition}{
Numeric (0 or 1). Are the symptoms NOT fully explained by other conditions (e.g., PUD, GERD)? (1 = Yes).
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least **6 months ago**? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have symptoms been active for the last **3 months**? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Functional Biliary Pain" or "Criteria Not Met".}
}
\references{
Corazziari E, Shaffer EA, Hogan WJ, et al. Functional Disorders of the Gallbladder and Sphincter of Oddi. Gastroenterology. 2016;150:1443-1455. doi:10.1053/j.gastro.2016.02.044
}
\examples{

# Example 1: Diagnosis Met
# Pain RUQ, Severe, Bouts, Other pain excluded, Normal imaging, Chronic duration
rome_iv_biliary_pain_criteria("ruq", 1, "bouts", 1, 1, 1, 1, 1)

# Example 2: Not Met (Not Chronic)
# All criteria met, but symptoms active for 1 month only
rome_iv_biliary_pain_criteria("epigastrium", 1, "steady", 1, 1, 1, 0, 1)
}
