\name{rhmp_30_score}
\alias{rhmp_30_score}
\title{
Rotterdam Hip Fracture Mortality Prediction 30 Days (RHMP-30)
}
\description{
Calculates the RHMP-30 Score to predict 30-day mortality in patients undergoing surgery for hip fracture. The score stratifies risk based on age, sex, ASA classification, and pre-injury housing status.
}
\usage{
rhmp_30_score(age, sex, asa_score, housing_status)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
<60: 0 pts.
60-69: 1 pt.
70-79: 2 pts.
80-89: 4 pts.
>=90: 6 pts.
}
  \item{sex}{
String. "Male" or "Female". (Male adds 2 pts).
}
  \item{asa_score}{
Numeric. ASA Physical Status Classification (1-5).
1-2: 0 pts.
3: 2 pts.
4: 4 pts.
5: 6 pts.
}
  \item{housing_status}{
String. Pre-injury living situation.
"independent" (Home/Community): 0 pts.
"institution" (Nursing Home/Assisted Living): 2 pts.
}
}
\value{
A list containing:
\item{RHMP_30_Score}{The calculated risk score (Range 0-16).}
\item{Est_30_Day_Mortality}{Estimated 30-day mortality risk category.}
}
\references{
Nijmeijer WS, et al. Prediction of early mortality following hip fracture surgery in frail elderly: The Rotterdam Score. Injury. 2016;47(10):2138-2143. doi:10.1016/j.injury.2016.07.022
}
\examples{

# Example 1: High Risk
# 85yo (+4), Male (+2), ASA 3 (+2), Institution (+2)
# Score = 10
rhmp_30_score(85, "male", 3, "institution")

# Example 2: Low Risk
# 65yo (+1), Female (0), ASA 2 (0), Independent (0)
# Score = 1
rhmp_30_score(65, "female", 2, "independent")
}
