\name{impact_head_injury_prognosis}
\alias{impact_head_injury_prognosis}
\title{
IMPACT Score for Head Injury Outcomes
}
\description{
Calculates the predicted 6-month probability of mortality and unfavorable outcome (Death, Vegetative State, or Severe Disability) in patients with moderate to severe Traumatic Brain Injury (TBI). This function implements the Extended Model (Clinical + CT findings) and optionally the Lab Model if glucose and hemoglobin are provided.
}
\usage{
impact_head_injury_prognosis(age, motor_score, pupils_reactive, ct_marshall_class,
                             tsah_present, epidural_mass_present,
                             glucose_mg_dl = NULL, hemoglobin_g_dl = NULL)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{motor_score}{
Numeric (1-6). Glasgow Coma Scale Motor Score.
1: None. 2: Extension. 3: Flexion (Abnormal). 4: Withdrawal. 5: Localizes. 6: Obeys.
}
  \item{pupils_reactive}{
Numeric (0, 1, or 2). Number of pupils reactive to light.
}
  \item{ct_marshall_class}{
Numeric (1-6). Marshall CT Classification.
1: Diffuse Injury I (No visible pathology).
2: Diffuse Injury II (Cisterns present, shift < 5mm, no high density > 25cc).
3: Diffuse Injury III (Cisterns compressed/absent, shift < 5mm, no high density > 25cc).
4: Diffuse Injury IV (Midline shift > 5mm, no high density > 25cc).
5: Evacuated Mass Lesion V.
6: Non-Evacuated Mass Lesion VI (> 25cc, not evacuated).
}
  \item{tsah_present}{
Numeric (0 or 1). Traumatic Subarachnoid Hemorrhage on CT? (1 = Yes).
}
  \item{epidural_mass_present}{
Numeric (0 or 1). Epidural Hematoma on CT? (1 = Yes). Note: Epidural hematomas are often associated with better outcomes compared to other lesions in this model.
}
  \item{glucose_mg_dl}{
Numeric (Optional). Admission serum glucose in mg/dL.
}
  \item{hemoglobin_g_dl}{
Numeric (Optional). Admission hemoglobin in g/dL.
}
}
\value{
A list containing:
\item{Predicted_6mo_Mortality}{The estimated probability of death at 6 months.}
\item{Predicted_6mo_Unfavorable_Outcome}{The estimated probability of an unfavorable outcome (GOSE 1-4) at 6 months.}
\item{Definitions}{Definitions of outcomes.}
}
\references{
Steyerberg EW, Mushkudiani N, Perel P, et al. Predicting outcome after traumatic brain injury: development and international validation of prognostic scores based on admission characteristics. PLoS Med. 2008;5(8):e165. doi:10.1371/journal.pmed.0050165
}
\examples{

# Example 1: Poor Prognosis
# 70yo, Motor 2, 0 Pupils, Marshall VI (Non-evac mass), tSAH, No Epidural
impact_head_injury_prognosis(70, 2, 0, 6, 1, 0)

# Example 2: Better Prognosis
# 25yo, Motor 5, 2 Pupils, Marshall II, No tSAH, Epidural present
impact_head_injury_prognosis(25, 5, 2, 2, 0, 1)
}
