\name{erefs_score}
\alias{erefs_score}
\title{
Eosinophilic Esophagitis Endoscopic Reference Score (EREFS)
}
\description{
Calculates the EREFS score, a standardized grading system for endoscopic findings in Eosinophilic Esophagitis (EoE). The score quantifies the severity of five major endoscopic features: Edema, Rings, Exudates, Furrows, and Strictures. It also provides subscores for inflammatory (Edema, Exudates, Furrows) and fibrostenotic (Rings, Stricture) features.
}
\usage{
erefs_score(edema, rings, exudates, furrows, stricture)
}
\arguments{
  \item{edema}{
Numeric (0-1). Presence of edema (loss of vascular markings).
0: Absent (distinct vascularity).
1: Present (decreased or absent vascularity/pallor).
}
  \item{rings}{
Numeric (0-3). Presence of trachealization/rings.
0: Absent.
1: Mild (ridges).
2: Moderate (distinct rings).
3: Severe (fixed rings, prevents scope passage).
}
  \item{exudates}{
Numeric (0-2). Presence of white plaques/exudates.
0: Absent.
1: Mild (<10\% of surface area).
2: Severe (>10\% of surface area).
}
  \item{furrows}{
Numeric (0-2). Presence of vertical lines/furrows.
0: Absent.
1: Mild (vertical lines without visible depth).
2: Severe (vertical lines with visible depth).
}
  \item{stricture}{
Numeric (0-1). Presence of stricture (narrowing).
0: Absent.
1: Present.
}
}
\value{
A list containing:
\item{EREFS_Total_Score}{The sum of all component scores (Range 0-9).}
\item{Subscores}{A list containing the Inflammatory Score (Range 0-5) and Fibrostenotic Score (Range 0-4).}
}
\references{
Hirano I, Moy N, Heckman MG, Thomas CS, Gonsalves N, Achem SR. Endoscopic assessment of the oesophageal features of eosinophilic oesophagitis: validation of a novel classification and grading system. Gut. 2013;62(4):489-495. doi:10.1136/gutjnl-2011-301817
}
\examples{

# Example 1: Mixed Phenotype
# Edema(1), Rings(2), Exudates(1), Furrows(1), Stricture(0)
# Total = 5 (Inflammatory 3, Fibrostenotic 2)
erefs_score(1, 2, 1, 1, 0)

# Example 2: Severe Inflammatory
# Edema(1), Rings(0), Exudates(2), Furrows(2), Stricture(0)
# Total = 5 (Inflammatory 5, Fibrostenotic 0)
erefs_score(1, 0, 2, 2, 0)
}
