\name{bclc_staging}
\alias{bclc_staging}
\title{
Barcelona Clinic Liver Cancer (BCLC) Staging
}
\description{
Determines the BCLC Stage, prognosis, and treatment recommendations for Hepatocellular Carcinoma (HCC). The classification uses Performance Status (ECOG), Tumor Burden, and Liver Function (Child-Pugh) to stratify patients into five stages (0, A, B, C, D).
}
\usage{
bclc_staging(ecog_ps, tumor_characteristics, child_pugh_class)
}
\arguments{
  \item{ecog_ps}{
Numeric (0-4). ECOG Performance Status.
}
  \item{tumor_characteristics}{
String. Extent of tumor burden. Options:
"single_lt_2cm": Single nodule < 2cm.
"single_gt_2cm_or_3_lt_3cm": Single nodule >= 2cm OR 3 nodules <= 3cm.
"multinodular": Multinodular.
"invasion_or_metastasis": Portal invasion or extrahepatic spread.
}
  \item{child_pugh_class}{
String. Child-Pugh Score Class ("A", "B", or "C").
}
}
\value{
A list containing:
\item{BCLC_Stage}{The calculated stage (0, A, B, C, or D).}
\item{Prognosis}{Estimated median survival.}
\item{Treatment_Recommendation}{Guideline-based treatment options.}
}
\references{
Llovet JM, Bru C, Bruix J. Prognosis of hepatocellular carcinoma: the BCLC staging classification. Semin Liver Dis. 1999;19(3):329-38. doi:10.1055/s-2007-1007122
Reig M, Forner A, Rimola J, et al. BCLC strategy for prognosis and treatment of hepatocellular carcinoma: The 2022 update. J Hepatol. 2022;76(3):681-693.
}
\examples{

# Example 1: Intermediate Stage
# PS 0, Multinodular, Child-Pugh A
bclc_staging(0, "multinodular", "A")

# Example 2: Advanced Stage
# PS 1, Single >2cm (Tumor burden is early, but PS 1 upgrades stage), Child-Pugh A
bclc_staging(1, "single_gt_2cm_or_3_lt_3cm", "A")

# Example 3: Terminal Stage
# PS 3
bclc_staging(3, "single_lt_2cm", "B")
}
