% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classicaltest.R
\name{classicaltest}
\alias{classicaltest}
\title{Classical test theory item and person statistics}
\usage{
classicaltest(
  x,
  key,
  navalue = NA,
  wt = NULL,
  itemcategories = NULL,
  administered = NULL,
  itemscores = NULL,
  maxscore = NULL
)
}
\arguments{
\item{x}{a data frame or matrix.}

\item{key}{a vector or a list indicating the keys to score the data.
If answers can only be right or wrong use a vector. If partial credits are allowed,
use a list where the first element contains the keys for full credits, and next
elements contain progressively the partial credit information.
If a test has a combination of full credit and partial credit items, leave
the full credit items as NAs in the keys for partial credit.}

\item{navalue}{a single value indicating the score of NAs.}

\item{wt}{a vector with total weights. Default is \code{NULL}.}

\item{itemcategories}{a vector indicating all the possible categories for all
items. If NULL, possible categories will be derived from data.}

\item{administered}{a logical matrix indicating which items were administered.
The dimensions should be the same as \code{x}. If \code{NULL} all items
are considered administered.}

\item{itemscores}{a numeric vector indicating all the possible scores for all items.
If \code{NULL}, possible scores will be derived from data.}

\item{maxscore}{a numeric value indicating which is the maximum score possible
per item. The minimum score is assumed to be 0. If \code{NULL} the maximum score is assumed to be
derived from the maximum value found in \code{x} or 1 if \code{x} only has 0s.}
}
\value{
A list with item and person statistics.
}
\description{
Calculates several item and person statistics following
\code{ctitem()}, and \code{ctperson()}.
}
\examples{
# Data preparation
## Random weights creation
set.seed(1919)
wt <- sample(x = 1:4, size = nrow(dichodata), replace = TRUE)

# Item and person analysis for multiple choice items
classicaltest(x = dichodata, key = dichokey, wt = wt)


}
