% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini4R.R
\name{gemini4R}
\alias{gemini4R}
\title{Gemini API Request (v1beta, 2025-07)}
\usage{
gemini4R(
  mode,
  contents,
  model = "gemini-2.0-flash",
  store_history = FALSE,
  api_key = Sys.getenv("GoogleGemini_API_KEY"),
  max_tokens = 2048,
  ...
)
}
\arguments{
\item{mode}{One of `"text"`, `"stream_text"`, `"chat"`, `"stream_chat"`.}

\item{contents}{Character vector (single-turn) or list of message objects
(chat modes).  See Examples.}

\item{model}{Gemini model ID.  Default `"gemini-2.0-flash"`.}

\item{store_history}{Logical.  If TRUE, chat history is persisted to the
`chat_history` env-var (JSON).}

\item{api_key}{Your Google Gemini API key (default: `Sys.getenv("GEMINI_API_KEY")`).}

\item{max_tokens}{Maximum output tokens.  NULL for server default.}

\item{...}{Additional `httr::POST` options (timeouts etc.).}
}
\value{
For non-stream modes, a parsed list.  For stream modes, a list with
        `full_text` and `chunks`.
}
\description{
A thin, dependency-light R wrapper for Google Gemini API
(`models.generateContent` / `models.streamGenerateContent`).
}
\examples{
\dontrun{
gemini4R("text",
         contents = "Explain how AI works.",
         max_tokens = 256)
}
}
\author{
Satoshi Kume (revised 2025-07-01)
}
