% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simData.R
\name{simulate_data}
\alias{simulate_data}
\title{Generate data with unmeasured confounder}
\usage{
simulate_data(
  ymodel = "linear",
  N = 500,
  u_type = "binary",
  y_type = "continuous",
  seed = 123,
  alpha_uz = 0.2,
  beta_uy = 0.5,
  treatment_effects = 1,
  informative_u = FALSE
)
}
\arguments{
\item{ymodel}{A string indicating the functional form of the outcome model.}

\item{N}{The number of observations to be generated.}

\item{u_type}{A string indicating the type of the unmeasured confounder:
"binary" or "continuous".}

\item{y_type}{A string indicating the type of the outcome: "binary" or
"continuous".}

\item{seed}{The seed for the random number generator.}

\item{alpha_uz}{Unmeasured confounder coefficient in the propensity score
model.}

\item{beta_uy}{Unmeasured confounder coefficient in the outcome model.}

\item{treatment_effects}{The treatment effect.}

\item{informative_u}{A boolean indicating whether the unmeasured confounder
is driven by covariates.}
}
\value{
A data frame with the simulated dataset.
}
\description{
Generate data with unmeasured confounder
}
