% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_distribution.R
\name{logistic_distribution}
\alias{logistic_distribution}
\alias{logistic_pdf}
\alias{logistic_lpdf}
\alias{logistic_cdf}
\alias{logistic_lcdf}
\alias{logistic_quantile}
\title{Logistic Distribution Functions}
\usage{
logistic_distribution(location = 0, scale = 1)

logistic_pdf(x, location = 0, scale = 1)

logistic_lpdf(x, location = 0, scale = 1)

logistic_cdf(x, location = 0, scale = 1)

logistic_lcdf(x, location = 0, scale = 1)

logistic_quantile(p, location = 0, scale = 1)
}
\arguments{
\item{location}{location parameter (default is 0)}

\item{scale}{scale parameter (default is 1)}

\item{x}{quantile}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Logistic distribution.
}
\examples{
# Logistic distribution with location = 0, scale = 1
dist <- logistic_distribution(0, 1)
# Apply generic functions
cdf(dist, 0.5)
logcdf(dist, 0.5)
pdf(dist, 0.5)
logpdf(dist, 0.5)
hazard(dist, 0.5)
chf(dist, 0.5)
mean(dist)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
standard_deviation(dist)
support(dist)
variance(dist)
skewness(dist)
kurtosis(dist)
kurtosis_excess(dist)

# Convenience functions
logistic_pdf(0)
logistic_lpdf(0)
logistic_cdf(0)
logistic_lcdf(0)
logistic_quantile(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/logistic_dist.html}{Boost Documentation} for more details on the mathematical background.
}
