% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{my_reorder}
\alias{my_reorder}
\title{Reorder the measurement dimensions to match the order for display}
\usage{
my_reorder(disp_order, raw_nm)
}
\arguments{
\item{disp_order}{The vector of names to be displayed (order matters)}

\item{raw_nm}{The vector of names from raw measurements (order matters)}
}
\value{
A permuted vector from 1 to \code{length(raw_nm)}. For example, if
its first element is 3, it means that the 3rd pathogen in \code{raw_nm}
should be arranged to the first in the raw measurements.
}
\description{
Reorder the measurement dimensions to match the order for display
}
\examples{
  disp_order <- c("B","E","D","C","F","A")
  raw_nm <- c("C","A","E")
  my_reorder(disp_order,raw_nm)


}
