% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modified.gtest.R
\name{modified.gtest}
\alias{modified.gtest}
\title{Zero-Tolerant G-Test for Contingency Tables}
\usage{
modified.gtest(x, log.p = FALSE)
}
\arguments{
\item{x}{a matrix or data frame of floating or integer
numbers to specify a contingency table. Entries
must be non-negative.}

\item{log.p}{a logical. If \code{TRUE}, 
the \emph{p}-value is calculated in
closed form to \strong{natural logarithm} of \emph{p}-value 
to improve numerical precision when
\emph{p}-value approaches zero.
Defaults to \code{FALSE}.}
}
\value{
A list with class \code{"htest"} containing:
\item{statistic}{the \emph{G} statistic (log-likelihood ratio).}
\item{parameter}{the degrees of freedom.}
\item{p.value}{the \emph{p}-value of the test.}
\item{estimate}{the value of mutual information.}
\item{method}{a character string indicating the method used.}
\item{data.name}{a character string, name of the input data.}
\item{observed}{the observed counts.}
\item{expected}{the expected counts under the null hypothesis.}
}
\description{
Performs \emph{G}-test 
  \insertCite{WOOLF:1957aa}{Upsilon} 
  on contingency tables, slightly modified 
  to handle rows or columns of all zeros.
}
\details{
This test is useful if a \emph{p}-value must be returned
  on a contingency table with valid non-negative counts,
  where other implementations of \emph{G}-test could 
  return \code{NA} as the \emph{p}-value, regardless of a 
  pattern being strong or weak.
  
  This function handles tables with empty rows
  or columns (where expected values are 0) by
  calculating the test statistic over non-zero
  entries only. This prevents the result from
  becoming \code{NA}, while giving meaningful
  \emph{p}-values.
}
\examples{
library("Upsilon")

# Create a sparse table with empty rows/cols
x <- matrix(
  c(0, 3, 0, 
    3, 0, 0), 
  nrow = 2, byrow = TRUE
)
print(x)
# Perform the modified G-test
modified.gtest(x)
}
\references{
\insertRef{WOOLF:1957aa}{Upsilon}
}
