% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modified.chisq.test.R
\name{modified.chisq.test}
\alias{modified.chisq.test}
\title{Zero-Tolerant Pearson's Chi-squared Test for Contingency Tables}
\usage{
modified.chisq.test(x, log.p = FALSE)
}
\arguments{
\item{x}{a matrix or data frame of floating or integer
numbers to specify a contingency table. Entries
must be non-negative.}

\item{log.p}{a logical. If \code{TRUE}, 
the \emph{p}-value is calculated in
closed form to \strong{natural logarithm} of \emph{p}-value 
to improve numerical precision when
\emph{p}-value approaches zero.
Defaults to \code{FALSE}.}
}
\value{
A list with class \code{"htest"} containing:
\item{statistic}{the chi-squared test statistic (calculated ignoring entries of 0-expected count).}
\item{parameter}{the degrees of freedom.}
\item{p.value}{the \emph{p}-value by the test.}
\item{estimate}{Cramér's \emph{V} statistic.}
\item{observed}{the observed counts.}
\item{expected}{the expected counts under the null hypothesis.}
}
\description{
Performs Pearson's chi-squared test 
  \insertCite{pearson1900}{Upsilon} 
  on contingency tables, slightly modified 
  to handle rows or columns of all zeros.
}
\details{
This test is useful if \emph{p}-value must be returned
  on a contingency table with valid non-negative counts,
  where the build-in R implementation of 
  \code{\link[stats]{chisq.test}} could return \code{NA}
  as \emph{p}-value, regardless of a pattern being
  strong or weak. See Examples.
  
  Unlike \code{\link[stats]{chisq.test}}, this
  function handles tables with empty rows or columns (where
  expected values are 0) by calculating the test
  statistic over non-zero entries only. This prevents
  the result from becoming \code{NA}, while giving
  meaningful \emph{p}-values.
}
\note{
This function only takes contingency table
  as input. It does not support goodness-of-fit
  test on vectors.
  It does \strong{not} offer an option
  to apply Yates's continuity correction 
  on 2 \eqn{\times} 2 tables.
}
\examples{
library("Upsilon")

# A table with a dominant function and an empty column
x <- matrix(
  c(0, 3, 0,
    3, 0, 0), 
   nrow = 2, byrow = TRUE)
print(x)

# Standard chisq.test fails or returns NA warning
chisq.test(x)

# Modified chi-squared test is significant:
modified.chisq.test(x)
}
\references{
\insertRef{pearson1900}{Upsilon}
}
