% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Controllers.R
\docType{class}
\name{Controllers}
\alias{Controllers}
\title{Class of Controller}
\description{
Create a class of controller to run a trial.

Public methods in this R6 class are used in developing
this package. Thus, we have to export the whole R6 class which exposures all
public methods. However, only the public methods in the list below are
useful to end users.

\itemize{
\item \code{$run()}
\item \code{$get_output()}
\item \code{$reset()}
}
}
\examples{
##
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Controllers-new}{\code{Controllers$new()}}
\item \href{#method-Controllers-get_listener}{\code{Controllers$get_listener()}}
\item \href{#method-Controllers-get_trial}{\code{Controllers$get_trial()}}
\item \href{#method-Controllers-mute}{\code{Controllers$mute()}}
\item \href{#method-Controllers-reset}{\code{Controllers$reset()}}
\item \href{#method-Controllers-get_output}{\code{Controllers$get_output()}}
\item \href{#method-Controllers-run}{\code{Controllers$run()}}
\item \href{#method-Controllers-clone}{\code{Controllers$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Controllers-new"></a>}}
\if{latex}{\out{\hypertarget{method-Controllers-new}{}}}
\subsection{Method \code{new()}}{
initialize a controller of the trial
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Controllers$new(trial, listener)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{trial}}{a trial object returned from \code{trial()}.}

\item{\code{listener}}{a listener object returned from \code{listener()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Controllers-get_listener"></a>}}
\if{latex}{\out{\hypertarget{method-Controllers-get_listener}{}}}
\subsection{Method \code{get_listener()}}{
return listener in a controller.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Controllers$get_listener()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Controllers-get_trial"></a>}}
\if{latex}{\out{\hypertarget{method-Controllers-get_trial}{}}}
\subsection{Method \code{get_trial()}}{
return trial in a controller.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Controllers$get_trial()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Controllers-mute"></a>}}
\if{latex}{\out{\hypertarget{method-Controllers-mute}{}}}
\subsection{Method \code{mute()}}{
mute all messages (not including warnings).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Controllers$mute()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{silent}}{logical.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Controllers-reset"></a>}}
\if{latex}{\out{\hypertarget{method-Controllers-reset}{}}}
\subsection{Method \code{reset()}}{
reset the trial and listener registered to the controller before running
additional replicate of simulation. This is usually done between two
calls of \code{controller$run()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Controllers$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Controllers-get_output"></a>}}
\if{latex}{\out{\hypertarget{method-Controllers-get_output}{}}}
\subsection{Method \code{get_output()}}{
return a data frame of all current outputs saved by calling \code{save()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Controllers$get_output(cols = NULL, simplify = TRUE, tidy = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cols}}{character vector. Columns to be returned from the data frame
of simulation outputs. If \code{NULL}, all columns are returned.}

\item{\code{simplify}}{logical. Return vector rather than a data frame of one
column when \code{length(cols) == 1} and \code{simplify == TRUE}.}

\item{\code{tidy}}{logical. \code{TrialSimulator} automatically records a set
of standard outputs at milestones, even when \code{doNothing} is used
as action functions. These includes time of triggering milestones,
number of observed events for time-to-event endpoints, and number of
non-missing readouts for non-TTE endpoints
(see \code{vignette('actionFunctions')}). This usually mean a large
number of columns in outputs. If users have no intent to summarize a
trial on these columns, setting \code{tidy = TRUE} can eliminate these
columns from \code{get_output()}. This is useful to reduced the size of
output data frame when a large number of replicates are done for
simulation. Note that currently we use regex
\code{"^n_events_<.*?>_<.*?>$"} and
\code{"^milestone_time_<.*?>$"} to match columns to be eliminated.
If users plan to use \code{tidy = TRUE}, caution is needed when naming
custom outputs in \code{save()}. Default \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Controllers-run"></a>}}
\if{latex}{\out{\hypertarget{method-Controllers-run}{}}}
\subsection{Method \code{run()}}{
run trial simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Controllers$run(n = 1, plot_event = TRUE, silent = FALSE, dry_run = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{integer. Number of replicates of simulation.
\code{n = 1} by default. Simulation results can be accessed by
\code{controller$get_output()}.}

\item{\code{plot_event}}{logical. Create event plot if \code{FALSE}. Users
should set it to be \code{FALSE} if \code{n > 1}.}

\item{\code{silent}}{logical. \code{TRUE} if muting all messages during a
trial. Note that warning messages are still displayed.}

\item{\code{dry_run}}{logical. We are considering retire this argument.
\code{TRUE} if action function provided by users is
ignored and an internal default action \code{.default_action} is called
instead. This default function only locks data when the milestone is
triggered. Milestone time and number of endpoints' events or sample sizes
are saved. It is suggested to set \code{dry_run = TRUE} to estimate
distributions of triggering time and number of events before formally
using custom action functions if a fixed design is in use.
This helps determining planned maximum
information for group sequential design and reasonable time of milestone
of interest when planning a trial. Set it to \code{FALSE} for formal
simulations. However, for an adaptive design where arm(s) could
possibly be added or removed, setting \code{dry_run} to \code{TRUE}
is usually not helpful because adaption should be executed
before estimating the milestone time.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Controllers-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Controllers-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Controllers$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
