% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensorreg_Wrapper.R
\name{tensor.reg}
\alias{tensor.reg}
\title{Tensor Regression using Rcpp}
\usage{
tensor.reg(
  z.train,
  x.train,
  y.train,
  nsweep = 50,
  rank = 2,
  scale = TRUE,
  alpha.lasso = 1
)
}
\arguments{
\item{z.train}{Matrix of scalar covariates (n x pgamma)}

\item{x.train}{3D array of tensor predictors (n x p x d)}

\item{y.train}{Response vector (length n)}

\item{nsweep}{Number of stochastic update iterations (default 50)}

\item{rank}{Rank of tensor decomposition (default 2)}

\item{scale}{whether to scale predictors and response (default TRUE)}

\item{alpha.lasso}{LASSO tuning parameter for initial estimate (default 1)}
}
\value{
A list with beta.store, gam.store, rank, p, d, and scaling info
}
\description{
Low-rank tensor regression with stochastic updates
}
