% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zeromonotoniccheck.R
\name{zeromonotoniccheck}
\alias{zeromonotoniccheck}
\title{0-monotonic check}
\usage{
zeromonotoniccheck(v, binary = FALSE, instance = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} is introduced in binary order instead of lexicographic order.}

\item{instance}{A logical value. By default, \code{instance=FALSE}.}
}
\value{
\code{TRUE} if the game is 0-monotonic, \code{FALSE} otherwise. If \code{instance=TRUE} and the game is not 0-monotonic, the function also returns the positions (binary order positions if \code{binary=TRUE}; lexicographic order positions otherwise) of a pair of coalitions violating 0-monotonicity.
}
\description{
This function checks if the given game is 0-monotonic.
}
\details{
A game \eqn{v\in G^N} is 0-monotonic if \eqn{v_0(S) \le v_0(T)} for all \eqn{S, T \in 2^N} such that \eqn{S\subset T}, being \eqn{v_0\in G^N} the 0-normalization of \eqn{v}.
}
\examples{
v <- c(0, 0, 0, 1, 1, 1, 2)
zeromonotoniccheck(v, binary = TRUE)
monotoniccheck(v, binary = TRUE)

w <- c(-2,-2,-2,7,7,7,6)
zeromonotoniccheck(w)
monotoniccheck(w)

z <- c(1, 1, 1, 2, 2, 2, 2)
zeromonotoniccheck(z)
monotoniccheck(z)
}
\seealso{
\link{monotoniccheck}, \link{zeronormalizedgame}, \link{zeronormalizedcheck}
}
