% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategicallyequivalentcheck.R
\name{strategicallyequivalentcheck}
\alias{strategicallyequivalentcheck}
\title{Strategically equivalent check}
\usage{
strategicallyequivalentcheck(v, w, binary = FALSE, parameters = FALSE)
}
\arguments{
\item{v}{A characteristic function, as a vector.}

\item{w}{A characteristic function, as a vector.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{v} and \code{w} are introduced in binary order instead of lexicographic order.}

\item{parameters}{A logical value. By default, \code{parameters=FALSE}.}
}
\value{
\code{TRUE} if \code{v} and \code{w} are strategically equivalent, \code{FALSE} otherwise. If \code{parameters=TRUE}, whenever \code{v} and \code{w} are strategically equivalent, the function also returns \code{k} (a positive integer) and \code{a} (the characteristic function of an additive game, as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise) such that \eqn{\code{v} = \code{k} \code{w} + \code{a}}.
}
\description{
This function checks if two games are strategically equivalent.
}
\details{
Games \eqn{v\in G^N} and \eqn{w\in G^N} are strategically equivalent if there exist \eqn{k>0} and an additive game \eqn{a\in G^N} such that \eqn{v(S)=k w(S)+a(S)} for all \eqn{S\in 2^N}.
}
\examples{
w <- c(1000, 0, 0, 2000, 3000, 2000, 4000)
v <- 4.5 * w + additivegame(c(4, 6, 1), binary = TRUE)
strategicallyequivalentcheck(v, w, binary = TRUE, parameters = TRUE)
}
\seealso{
\link{additivegame}, \link{normalizedgame}, \link{zeronormalizedgame}
}
