% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa_generics.R, R/class_OMs.R, R/class_Slick.R
\docType{methods}
\name{OMs}
\alias{OMs}
\alias{OMs<-}
\alias{OMs,missing-method}
\alias{OMs,dataframe_list-method}
\alias{OMs,Slick-method}
\alias{OMs<-,Slick-method}
\title{Methods for Creating, Accessing and Assigning \code{OMs} objects}
\usage{
OMs(Factors = data.frame(), Design = data.frame(), Preset = list())

OMs(object) <- value

\S4method{OMs}{missing}()

\S4method{OMs}{dataframe_list}(Factors = data.frame(), Design = data.frame(), Preset = list())

\S4method{OMs}{Slick}(Factors)

\S4method{OMs}{Slick}(object) <- value
}
\arguments{
\item{Factors}{A \code{data.frame} with column headings \code{Factor}, \code{Level}, and \code{Description}.
See \code{Details}}

\item{Design}{A \code{data.frame} with \code{nFactor} columns
(i.e., \code{length(unique(Factors$Factor))}), and \code{nOM}
rows. See \code{Details}}

\item{Preset}{An optional named list for the preset buttons in the \code{\link[=App]{App()}}. The name of the list
element will appear as a button in the \code{\link[=App]{App()}}.. See \code{Details} and `Examples}

\item{object}{A \code{\link[=Slick-class]{Slick-class()}} object}

\item{value}{A \code{\link[=OMs-class]{OMs-class()}} object}
}
\description{
The \code{OMs} function is used both to create and modify an \code{\link[=OMs-class]{OMs-class()}} object.
and to access and assign \code{OMs} for an object of class \code{\link[=Slick-class]{Slick-class()}}.
See \code{Details}.
}
\details{
\subsection{Factors}{

\code{Factors} can be accessed and assigned using \code{Factors(myslick)} and
\code{Factors(myslick) <- data.frame()} respectively.

The \code{Factor} column should be character strings with the name of each factor,
while the \code{Level} column is a \code{numeric} or \code{character} value with the level for the
corresponding factor.

The \code{Description} column is a description for each row, i.e., a unique factor and level.
See \code{Examples}.
}

\subsection{Design}{

The \code{Design} matrix is \code{nOM} rows and \code{nFactor} columns. The values in each column should
either be \code{numeric} values indicating the levels for the corresponding factor,
or the actual level values (i.e., \code{Factors$Level}) that correspond to each OM. See \code{Examples}.
}

\subsection{Preset}{

For \code{OMs} objects, \code{Preset} should be a named list, where each list element represents a
different preset button to be shown in the app by the name of the list element, and
each named list element should be a list of length \code{nFactors}, with the list elements
for each Factor containing numeric values indicating the levels to include for that factor.
See \code{Examples}

Use \code{\link[=Factors]{Factors()}}, \code{\link[=Design]{Design()}}, and \code{\link[=Preset]{Preset()}} to access
and assign the values for an existing \code{OMs} object, see \code{Examples}.
}
}
\section{Functions}{
\itemize{
\item \code{OMs(missing)}: Create an empty \code{OMs} object

\item \code{OMs(dataframe_list)}: Create a populated \code{OMs} object

\item \code{OMs(Slick)}: Return an \code{\link[=OMs-class]{OMs-class()}} object from a \code{\link[=Slick]{Slick()}} object

\item \code{OMs(Slick) <- value}: Assign an \code{\link[=OMs-class]{OMs-class()}} object to a \code{\link[=Slick]{Slick()}} object

}}
\examples{

# Create Object
oms <- OMs()

# Specify Factors
Factors(oms) <- data.frame(Factor='M',
                           Level=c('Base', 'Low M', 'High M'),
                           Description=c('Base Case',
                                         'Lower Natural Mortality',
                                         'Higher Natural Mortality')
)

Factors(oms)

# OM Design

Design(oms) <- data.frame(M=c('Base', 'Low M', 'High M'))

# Add names for OMs
rownames(Design(oms)) <- c('Base Case', 'Less Productive', 'More Productive')

Design(oms)

# Preset

Preset(oms) <- list('Base Case'=list(1),
                    'Low M' = list(2),
                    'High M' = list(3),
                    'All'= list(1:3)
)

# Create Slick Object
myslick <- Slick()

# Add OMs to Slick Object
OMs(myslick) <- oms
}
\seealso{
\code{\link[=OMs-class]{OMs-class()}}, \code{\link[=Factors]{Factors()}}, \code{\link[=Design]{Design()}}, \code{\link[=Preset]{Preset()}}
}
